-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.limit = {}
    self.limit[0] = 180 / Citadels.GetPlayer(0):GetDifficultyCoef()
    self.limit[1] = 240 / Citadels.GetPlayer(0):GetDifficultyCoef()
    self.limit[2] = 360 / Citadels.GetPlayer(0):GetDifficultyCoef()
    
    if not self.loaded then
      self.active = false
      self.timer = self.limit[0]
      self.attCount = 0
    end
    
    self.waveTown:LinkToTarget("toAtt")
    self.waveSmallTown:LinkToTarget("stAtt")
    self.waveMeadow:LinkToTarget("mdAtt")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      self.attCount = self.attCount + 1
      self.timer = self.limit[self.attCount]
      SendAttack(self)
    end  
  end  
end

function SendAttack(self)
  if self.attCount == 1 then
    self.waveTown:TriggerAllTargets()
  elseif self.attCount == 2 then
    self.waveSmallTown:TriggerAllTargets()
  elseif self.attCount == 3 then
    self.waveMeadow:TriggerAllTargets()
    self.attCount = 0
  end
	self.active = false
end

function OnTrigger(self, source, target)
  if target == "activateAttacks" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
    self.attCount = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
    ar:Write(self.attCount)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerSource("waveTown")
  self:AddTriggerSource("waveSmallTown")
  self:AddTriggerSource("waveMeadow")
end

function CreateTriggerSources(self)
  self:AddTriggerTarget("activateAttacks")
end
